/**
* \file: AlsaAudioSink.cpp
*
* \version: $Id:$
*
* \release: $Name:$
*
* <brief description>.
* <detailed description>
* \component: Android Auto
*
* \author: I. Hayashi / ADITJ/SW / ihayashi@jp.adit-jv.com
*
* \copyright (c) 2014 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#include "AlsaAudioSink.h"
#include "AlsaAudioSinkImpl.h"

namespace adit { namespace aauto {

AlsaAudioSink::AlsaAudioSink(uint8_t inSessionId, MessageRouter* inMessageRouter) :
                AditAudioSink(inSessionId, inMessageRouter)
{
    impl = new AlsaAudioSinkImpl(this);
}

AlsaAudioSink::~AlsaAudioSink()
{
    /* This impl pointer is deleted at shared_ptr in callbak impl on GalReceiver */
}

bool AlsaAudioSink::init()
{
    return impl->init();
}
void AlsaAudioSink::shutdown()
{
    impl->shutdown();
}
void AlsaAudioSink::setConfigItem(string inKey, string inValue)
{
    return impl->setConfigItem(inKey, inValue);
}

void AlsaAudioSink::registerCallbacks(IAditAudioSinkCallbacks* inCallbacks)
{
    return impl->registerCallbacks(inCallbacks);
}

} } /* namespace adit { namespace aauto { */
